% 

clear all
clf

% numerical data files
eta_fname='zeta.nc';
velo_fname='velo.nc';

time_numerical=ncread(eta_fname,'time');
x_numerical=ncread(eta_fname,'x');
zeta=squeeze(ncread(eta_fname,'zeta'));  % squeeze to get rid of y-dimension index
u_vel=squeeze(ncread(velo_fname,'u_velo'));  % squeeze to get rid of y-dimension index

% numerical shift values - numerical domain was not same as physical domain
x_shift=-10.;  % added 10-m to offshore boundary to create wave
t_shift=20-1.4;  % cut off first 20 ish seconds since nothing happened;

time=time_numerical+t_shift;
x=x_numerical+x_shift;

%% offshore wave gages
load WG2_6.txt
figure(1)
subplot(3,1,1); hold on; box on  % offshore wave gages (WG 2)
plot(WG2_6(:,1),WG2_6(:,2) , 'r-', 'LineWidth', 1)
hold on
plot(WG2_6(:,1),WG2_6(:,3), 'k-', 'LineWidth', 1)

% modeled data
WG2_loc=2.26;
WG2_num=interp2(time,x,zeta,time,WG2_loc);
plot(time,WG2_num,'r--')

WG6_loc=19.22;
WG6_num=interp2(time,x,zeta,time,WG6_loc);
plot(time,WG6_num,'k--')

axis([20 55 -0.05 .5])
legend ('WG2 Data','WG6 Data','WG2 Model','WG6 Model')
xlabel('Time(s)')
ylabel('\eta (m)')

%% nearshore US wave gages
load USWG3.txt
load USWG4.txt

subplot(3,1,2)
plot(USWG3(:,1),USWG3(:,2),'r')
hold on
plot(USWG4(:,1),USWG4(:,2),'k')

% modeled data
WG3_loc=30.68;
WG3_num=interp2(time,x,zeta,time,WG3_loc);
plot(time,WG3_num-WG3_num(2),'r--')

WG4_loc=31.89;
WG4_num=interp2(time,x,zeta,time,WG4_loc);
plot(time,WG4_num-WG4_num(2),'k--')

axis([20 55 -.05 .2])
legend ('usWG3 Data','usWG4 Data','usWG3 Model','usWG4 Model')
ylabel('\eta (m)')
xlabel('Time(s)')

%% nearshore ADV
load ADV2.txt
subplot(3,1,3)
plot(ADV2(:,1),ADV2(:,2))
hold on
ADV2_loc=WG4_loc;
ADV2_num=interp2(time,x,u_vel,time,ADV2_loc);
plot(time,ADV2_num,'k--')

axis([20 55 -1.2 2.5])
legend ('ADV2 Data','ADV2 Model')
xlabel('Time(s)')
ylabel('u (m/s)')

print -djpeg100 model_data_comp.jpg 
