% 

clear all
clf

% numerical data files
eta_fname='zeta.nc';
velo_fname='velo.nc';

time_numerical=ncread(eta_fname,'time');
x_numerical=ncread(eta_fname,'x');
zeta=squeeze(ncread(eta_fname,'zeta'));  % squeeze to get rid of y-dimension index
u_vel=squeeze(ncread(velo_fname,'u_velo'));  % squeeze to get rid of y-dimension index

% numerical shift values - numerical domain was not same as physical domain
x_shift=-10.;  % added 10-m to offshore boundary to create wave
t_shift=13.1;  % cut off first 13 ish seconds since nothing happened;

time_num_shift=time_numerical+t_shift;
x=x_numerical+x_shift;

%% offshore wave gages
load time.txt
dt=mean(diff(time));
load wg1.txt
wg1=wg1(1:length(time));  % for some reason the gage data is a different length than time; truncate first few time steps - may need to adjust timing of model-data comps to account for this
load wg9.txt
wg9=wg9(1:length(time)); 
% wave gage data has some strange high-freq noise.  Low-pass to remove
pass_per=0.5;  % seconds
wg1_hp=highpass(wg1,1/pass_per,1/dt,'Steepness',0.9999);
wg1=wg1-wg1_hp;
wg9_hp=highpass(wg9,1/pass_per,1/dt,'Steepness',0.9999);
wg9=wg9-wg9_hp;

figure(1)
subplot(3,1,1); hold on; box on  % offshore wave gages (WG 2)
plot(time,wg1 , 'r-', 'LineWidth', 1)
hold on
plot(time,wg9, 'k-', 'LineWidth', 1)

% modeled data
WG5_loc=14.052;
WG5_num=interp2(time_num_shift,x,zeta,time_num_shift,WG5_loc);
plot(time_num_shift,WG5_num,'r--')

WG9_loc=19.246;
WG9_num=interp2(time_num_shift,x,zeta,time_num_shift,WG9_loc);
plot(time_num_shift,WG9_num,'k--')

axis([20 55 -0.05 .15])
legend ('WG1 Data','WG9 Data','WG1 Model','WG9 Model')
xlabel('Time(s)')
ylabel('\eta (m)')

%% nearshore US wave gages
load uswg5.txt
uswg5=uswg5(1:length(time));  

load uswg_h_1_5_7_v2.txt
time_ush=uswg_h_1_5_7_v2(:,1);
USWG5h=uswg_h_1_5_7_v2(:,4);

subplot(3,1,2)
plot(time,uswg5,'r')
hold on
plot(time_ush,USWG5h,'k')

% modeled data
WG5_loc=28.29;
WG5_num=interp2(time_num_shift,x,zeta,time_num_shift,WG5_loc);
plot(time_num_shift,WG5_num-WG5_num(2),'r--')

WG5h_loc=35.531;
WG5h_num=interp2(time_num_shift,x,zeta,time_num_shift,WG5h_loc);
plot(time_num_shift,WG5h_num-WG5h_num(2),'k--')

axis([20 55 -.05 .15])
legend ('usWG5 Data','usWG_h5 Data','usWG5 Model','usWG_h5 Model')
ylabel('\eta (m)')
xlabel('Time(s)')

%% nearshore ADV
load ADVh_1_5_7.txt
time_ADV=ADVh_1_5_7(:,1);
ADV5=ADVh_1_5_7(:,3);

subplot(3,1,3)
plot(time_ADV,ADV5)
hold on
ADV5_loc=WG5h_loc;
ADV5_num=interp2(time_num_shift,x,u_vel,time_num_shift,ADV5_loc);
plot(time_num_shift,ADV5_num,'k--')

axis([20 55 -1.2 2.5])
legend ('ADV5_h Data','ADV5_h Model')
xlabel('Time(s)')
ylabel('u (m/s)')

print -djpeg100 model_data_comp.jpg 
