% Create figure that compares centroid paths and velocities for three
% configs that have induced rotation (the fourth is the joined 2x2 box).

clear all
clf

figure(1)
subplot(1,3,1)
hold on
subplot(1,3,[2 3])
hold on

%% Config 1 -- 1 Boxe, Straight

load('Config1.Track.mat')
xy = Config_1_Box(:,2:3)';
xy(1,:)=xy(1,:);
subplot(1,3,1); plot(xy(2,:),xy(1,:),'g.-')
subplot(1,3,[2 3])
u = Config_1_Box(:,4);
t = Config_1_Box(:,1);
plot(t, u, 'g.-')
u1=u;
t1=t;
xy1=xy;



%% Config 3 -- 4 Boxes, Straight

load('Config3.Track.mat')
results(:,3,:) = results(:,3,:) + 1.32;
xy = squeeze(mean(results(:,[3 2],:)));
subplot(1,3,1); plot(xy(1,:),xy(2,:),'k.-')
subplot(1,3,[2 3])
u = squeeze(mean(diff(results(:,2,:),[],3)/0.5, 1));
t = t(1:end-1) + diff(t)/2;
plot(t, u, 'k.-')
u3=u;
t3=t;
xy3=xy;
%% Config 4 -- 4 Boxes, Rotated

load('Config4.Track.mat')
results(:,3,:) = results(:,3,:) + 1.32;
xy = squeeze(mean(results(:,[3 2],:)));
subplot(1,3,1); plot(xy(1,:),xy(2,:),'b.-')
subplot(1,3,[2 3])
u = squeeze(mean(diff(results(:,2,:),[],3)/0.5, 1));
t = t(1:end-1) + diff(t)/2;
plot(t, u, 'b.-')
u4=u;
t4=t;
xy4=xy;
%% Config 12 -- 4 Joined Boxes, Rotated

load('Config12.Track.mat')
results(:,3,:) = results(:,3,:) + 1.32;
xy = squeeze(mean(results(:,[3 2],:)));
subplot(1,3,1); plot(xy(1,:),xy(2,:),'r.-')
subplot(1,3,[2 3])
u = diff(xy(2,:))/0.5;
t = t(1:end-1) + diff(t)/2;
plot(t, u, 'r.-')
u12=u;
t12=t;
xy12=xy;


%% Plot Data

subplot(1,3,1)
rectangle('Position',[0.22,34.34,0.60,0.60])  % Row 1
rectangle('Position',[0.82,34.34,0.60,0.60])
rectangle('Position',[0.22,34.94,0.60,0.60])  % Row 2
rectangle('Position',[0.82,34.94,0.60,0.60])
rectangle('Position',[1.22,35.54,0.60,0.60],'FaceColor',[0.7 0.7 0.7])  % Stationary
set(gca,'FontSize',12)
axis ij; axis([-2.25 2 34 41.7]); box on
xlabel('y (m)','FontSize',12)
ylabel('x (m)','FontSize',12)
legend('Config 1','Config 3','Config 4','Config 12')

subplot(1,3,[2 3])
plot([20, 60],[0, 0],'k:')
set(gca,'FontSize',12)
box on; axis([30 60 -1.0 1.8])
xlabel('time (s)','FontSize',12)
ylabel('u (m/s)','FontSize',12)
legend('Config 1','Config 3','Config 4','Config 12')

%% Save Data in simple ASCII text files
% Config 3 data
data=[t1 xy1' u1];  % time, xposition, yposition, cross-shore velo
save config1_vel.txt data -ascii

% Config 3 data
data=[t3' fliplr(xy3(:,2:end)') u3];  % time, xposition, yposition, cross-shore velo
save config3_vel.txt data -ascii

% Config 4 data
data=[t4' fliplr(xy4(:,2:end)') u4];  % time, xposition, yposition, cross-shore velo
save config4_vel.txt data -ascii

% Config 12 data
data=[t12' fliplr(xy12(:,2:end)') u12'];  % time, xposition, yposition, cross-shore velo
save config12_vel.txt data -ascii

print -djpeg100 configs.jpg

















