% Create QuickLook-style figure of instrumentation
% measurements for HouseSmash2 experiment.

clear all
clf

%% Load Stuff
DAQ1 = load('gauge_data.txt');

%% Sync DAQpxi1 using WMStart Signal
wmstart = find(DAQ1(:,2) > 4.0, 1);
DAQ1(1:wmstart-1,:) = [];
t_DAQ1 = ((1:size(DAQ1,1))-1)'*0.02;

% offshore wave gages
figure(1)
subplot(3,1,1); hold on; box on  % offshore wave gages (WG 2)
WG2_data=(DAQ1(:,9)-DAQ1(1,8))*.235;
plot(t_DAQ1-0.7, WG2_data , 'r-', 'LineWidth', 1)  % WG data is apparently shifted 0.7 seconds forward. Not sure why, but it is clear.
xlabel('Time(s)')
ylabel('\eta (m)')

% offshore wave gages (WG 6)
WG6_data=(DAQ1(:,13)-DAQ1(1,12))*.235;
plot(t_DAQ1-0.7,WG6_data, 'k-', 'LineWidth', 1)
axis([20 55 -0.05 .45])
legend ('WG2','WG6')
data=[t_DAQ1-0.7 WG2_data WG6_data];
save WG2_6.txt data -ascii

% nearshore US wave gages
load USWG3.txt
load USWG4.txt

subplot(3,1,2)
plot(USWG3(:,1),USWG3(:,2),'r')
hold on
plot(USWG4(:,1),USWG4(:,2),'k')
axis([20 55 -.05 .2])
legend ('usWG3','usWG4')
ylabel('\eta (m)')
xlabel('Time(s)')

% nearshore ADV
load ADV2.txt
subplot(3,1,3)
plot(ADV2(:,1),ADV2(:,2))
axis([20 55 -1.2 2.5])
legend ('ADV2')
xlabel('Time(s)')
ylabel('u (m/s)')

print -djpeg100 wave_data.jpg