% Create QuickLook-style figure of wavemaker displacement

clear all
close all

%% Wavemaker Load data
DAQ1 = load('wmdisp.txt');

%% Sync DAQpxi1 using WMStart Signal
wmstart = find(DAQ1(:,2) > 4.0, 1);
DAQ1(1:wmstart-1,:) = [];
t_DAQ1 = ((1:size(DAQ1,1))-1)'*0.02;

figure(1)
subplot(2,1,1)
hold on; box on  % WM displacement and wave gage
plot(t_DAQ1, DAQ1(:,3)*0.23, 'r-', 'LineWidth', 2)
axis([20 40 -1.25 1.25])
xlabel('Time(s)')
ylabel('Wavemaker Displacement(m)')


%% Load WG2 data
load WG2_6.txt
time=WG2_6(:,1);
WG2=WG2_6(:,2);
subplot(2,1,2)
hold on; box on  % WM displacement and wave gage
plot(time, WG2, 'r-', 'LineWidth', 2)
axis([20 40 -.05 0.35])
xlabel('Time(s)')
ylabel('water Elevation at WG2(m)')

print -djpeg100 wm_and_wg2.jpg
