% load and plot Case 1 final debris locations
clear all
clf

load Case1_HDPE.txt  % datafile with final x and y coordinates of each debris box
load Case1_Wood.txt
% load and plot Case 1 final debris locations
clear all
clf

load Case1_HDPE.txt  % datafile with final x and y coordinates of each debris box
load Case1_Wood.txt

Case1_HDPE=Case1_HDPE/100; % convert from cm to m
Case1_Wood=Case1_Wood/100; % convert from cm to m

%% plot HDPE
subplot(1,2,1)
x0=31.29;  % initial x-location of start of particle group
y0_HDPE=3.00;  % initial y-center of particle group
plot(Case1_HDPE(:,1)-y0_HDPE,Case1_HDPE(:,2)+x0,'o','MarkerFaceColor','r','MarkerEdgeColor','k')
hold on
% plot initial particle locations
box_side=10.2/100; % side length of debris box
box_spacing=box_side/2;
for i=1:4
    x_loc=x0+box_side/2+(i-1)*(box_spacing+box_side);

    for j=-2:2
        y_loc=j*(box_spacing+box_side);
        plot(y_loc,x_loc,'o','MarkerFaceColor','k','MarkerEdgeColor','k')
    end
end
axis equal
axis([-3 3 0+x0 10.00+x0])
xlabel('Alongshore Coordinate, y, relative to initial center of debris group (m)')
ylabel('Cross-shore Coordinate, x, relative to wavemaker (m)')
title('Initial (black) and final (red) locations of HDPE debris particles')

%% plot Wood
subplot(1,2,2)
x0=31.29;  % initial x-location of start of particle group
y0_Wood=7.00;  % initial y-center of particle group
plot(Case1_Wood(:,1)-y0_Wood,Case1_Wood(:,2)+x0,'o','MarkerFaceColor','y','MarkerEdgeColor','k')
hold on
% plot initial particle locations
box_side=10.2/100; % side length of debris box
box_spacing=box_side/2;
for i=1:4
    x_loc=x0+box_side/2+(i-1)*(box_spacing+box_side);
    for j=-2:2
        y_loc=j*(box_spacing+box_side);
        plot(y_loc,x_loc,'o','MarkerFaceColor','k','MarkerEdgeColor','k')
    end
end
axis equal
axis([-3 3 0+x0 10.00+x0])
xlabel('Alongshore Coordinate, y, relative to initial center of debris group (m)')
ylabel('Cross-shore Coordinate, x, relative to wavemaker (m)')
title('Initial (black) and final (yellow) locations of Wood debris particles')

%% Calc statistics
% Mean longitudinal distance from centroid of particles
xc=x0+2*box_side+1.5*box_spacing;  % x-centroid
x_distance_traveled=Case1_HDPE(:,2)+x0-xc;
mean_x_dist_HDPE=mean(x_distance_traveled);

x_distance_traveled=Case1_Wood(:,2)+x0-xc;
mean_x_dist_Wood=mean(x_distance_traveled);

% Standard Deviation of Lateral Spreading
stdev_y_HDPE=std(Case1_HDPE(:,1));
stdev_y_Wood=std(Case1_Wood(:,1));

% Standard Deviation of Longitindal Spreading
stdev_x_HDPE=std(Case1_HDPE(:,2));
stdev_x_Wood=std(Case1_Wood(:,2));

% Add info to Figure
subplot(1,2,1)
text(-2.8, 33.5,['Mean Cross-shore Distance Traveled (m): ' num2str(mean_x_dist_HDPE)])
text(-2.8, 33.0,['Lateral spreading - stdev of final y position (m): ' num2str(stdev_y_HDPE)])
text(-2.8, 32.5,['Longitidinal spreading - stdev of final x position (m): ' num2str(stdev_x_HDPE)])

% Add info to Figure
subplot(1,2,2)
text(-2.8, 33.5,['Mean Cross-shore Distance Traveled (m): ' num2str(mean_x_dist_Wood)])
text(-2.8, 33.0,['Lateral spreading - stdev of final y position (m): ' num2str(stdev_y_Wood)])
text(-2.8, 32.5,['Longitidinal spreading - stdev of final x position (m): ' num2str(stdev_x_Wood)])

print -djpeg100 Case12_debris.jpg


