% 

clear all
clf


%% offshore wave gages
load time.txt
dt=mean(diff(time));
load wg1.txt
wg1=wg1(1:length(time));  % for some reason the gage data is a different length than time; truncate first few time steps - may need to adjust timing of model-data comps to account for this
load wg9.txt
wg9=wg9(1:length(time)); 
% wave gage data has some strange high-freq noise.  Low-pass to remove
pass_per=0.5;  % seconds
wg1_hp=highpass(wg1,1/pass_per,1/dt,'Steepness',0.9999);
wg1=wg1-wg1_hp;
wg9_hp=highpass(wg9,1/pass_per,1/dt,'Steepness',0.9999);
wg9=wg9-wg9_hp;

figure(1)
subplot(3,1,1); hold on; box on  % offshore wave gages (WG 2)
plot(time,wg1 , 'r-', 'LineWidth', 1)
hold on
plot(time,wg9, 'k-', 'LineWidth', 1)

axis([20 55 -0.05 .15])
legend ('WG1 Data','WG9 Data')
xlabel('Time(s)')
ylabel('\eta (m)')

%% nearshore US wave gages
load uswg5.txt
uswg5=uswg5(1:length(time));  

load uswg_h_1_5_7_v2.txt
time_ush=uswg_h_1_5_7_v2(:,1);
USWG5h=uswg_h_1_5_7_v2(:,4);

subplot(3,1,2)
plot(time,uswg5,'r')
hold on
plot(time_ush,USWG5h,'k')

axis([20 55 -.05 .15])
legend ('usWG5 Data','usWG_h5 Data')
ylabel('\eta (m)')
xlabel('Time(s)')

%% nearshore ADV
load ADVh_1_5_7.txt
time_ADV=ADVh_1_5_7(:,1);
ADV5=ADVh_1_5_7(:,3);

subplot(3,1,3)
plot(time_ADV,ADV5)
hold on

axis([20 55 -1.2 2.5])
legend ('ADV_h5 Data')
xlabel('Time(s)')
ylabel('u (m/s)')

print -djpeg100 wave_data.jpg 
