% Create QuickLook-style figure of wavemaker displacement

clear all
close all

%% Load wavemaker data
DAQ1 = load('wmdisp15.txt');
load time.txt
DAQ1=DAQ1(1:length(time));  % for some reason the wavemkaer data is a different length than time; truncate first few time steps - may need to adjust timing of model-data comps to account for this

figure(1)
subplot(2,1,1)
hold on; box on  % WM displacement and wave gage
plot(time, DAQ1, 'r-', 'LineWidth', 2)
axis([0 40 -1.25 1.25])
xlabel('Time(s)')
ylabel('Wavemaker Displacement(m)')


%% Load WM_WG data
DAQ2 = load('wmwg15.txt');
load time.txt
DAQ2=DAQ2(1:length(time));  % for some reason the wavemkaer data is a different length than time; truncate first few time steps - may need to adjust timing of model-data comps to account for this

figure(1)
subplot(2,1,2)
hold on; box on  % WM displacement and wave gage
plot(time, DAQ2, 'r-', 'LineWidth', 2)
axis([0 40 -0.05 0.1])
xlabel('Time(s)')
ylabel('Wave Gage at Wavemaker (m)')


print -djpeg100 wm_and_wmwg.jpg