%
% reading data and make figure
%

clear
fclose all ;

% for reading all data 
load('../raw_data/data.mat') ;

%  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  = 
% Data Contents in data.mat

% 1. bathyData -- nx,ny: mesh number in each direction
%              -- X(nx), Y(ny): Coordinate information
%              -- Manning(nx,ny): Manning coefficient used in my simulation 
%              -- landFlag(nx,ny): land=1, water=0
%              -- depth(nx,ny): bathymetry and topography data used in my simulation 

%% figure
% exp
X=bathyData.X ;
Y=bathyData.Y ;
topo=bathyData.depth ;
[nx,ny]=size(topo);

figure(1)
clf
% bath/topo data 
pcolor(X,Y,topo') ;
shading flat ;
axis equal tight; hold on ;
set(gca,'Ydir','reverse') ;
xlabel('X [m]') ; 
ylabel('Y [m]') ; 
title('City Layout')
print -djpeg100 bathytopo.jpg

save x_lab.txt X -ascii
save y_lab.txt Y -ascii
save z_lab.txt topo -ascii


