%
% reading data and make figure
%

close all ;
clear
fclose all ;

len=0.25; % length of debris objects 
wid=0.10; % width of debris objects

% for reading all data 
load('./data.mat') ;

%  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  = 
% Data Contents in data.mat

% Three variables with structure arrays are included
%     : bathyData is the bathymetry and topography data etc used in my
%       simulation
%     : FDcase is the data of Floating Debris case
%     : LDcase is the data of Land Debris case

% 1. bathyData -- nx,ny: mesh number in each direction
%              -- X(nx), Y(ny): Coordinate information
%              -- Manning(nx,ny): Manning coefficient used in my simulation 
%              -- landFlag(nx,ny): land=1, water=0
%              -- depth(nx,ny): bathymetry and topography data used in my simulation 

% 2. FDcase
%              -- caseNo: case number (1~10) (nCase)
%              -- TimeAtWaveGauge: Time[s] of wave gauge data (ntWave)
%              -- Time: Time[s] of debris data (ntDebris)
%              -- waveDataAtGauge1(nCase,ntWave): time series of measured wave height at WG1
%              -- waveDataAtGauge2(nCase,ntWave): time series of measured wave height at WG2
%              -- CenterX(nCase,ntDebris), CenterY(nCase,ntDebris): time series of center position of debris object
%              -- CornerX(nCase,ntDebris), CornerY(nCase,ntDebris): time series of corner position of debris object
%              -- RotationAngle(nCase,ntDebris): time series of rotataion anlge of debris 

% 3. LDcase 
%              -- same as FDcase
%  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  = 


%% figure
% exp
X=bathyData.X ;
Y=bathyData.Y ;
[XX,YY]=meshgrid(X,Y) ; XX=XX' ; YY=YY' ;


figure;
% bath/topo data 
pcolor(XX,YY,bathyData.depth) ;
shading flat ;
caxis([-0.1 0.1]) ; axis equal tight; hold on ;
set(gca,'Ydir','reverse') ;
xlabel('X [m]') ; 
ylabel('Y [m]') ; 
title('Initial position')
xlim([0 8])

% plot initial debris position for FD case
num=FDcase.caseNo ;
for i=1:1:length(num)
    x=FDcase.CenterX ;
    y=FDcase.CenterY ;
    t=FDcase.RotationAnlge ;
    % this function(func_vertex) is calculated the position of debris
    % vertex using the center of gravity, rotation angle, width and length. 
    % I stored this function in the same folder as the data. 
    [xd,yd]=func_vertex(x(i,1),y(i,1),-t(i,1),len,wid) ;
    plot(xd,yd) ;
end

% plot initial debris position for LD case
num=LDcase.caseNo ;
for i=1:1:length(num)
    x=LDcase.CenterX ;
    y=LDcase.CenterY ;
    t=LDcase.RotationAnlge ;
    [xd,yd]=func_vertex(x(i,1),y(i,1),-t(i,1),len,wid) ;
    plot(xd,yd) ;
end

%%
% make figure for debris trajectory and time series of wave height in each
% experiment case 
% the figures "FD_case01-06.png", "FD_case07-10.png", "LD_case01-06.png", "LD_case07-10.png"
% are based on the following program. 

% for FD case
x=FDcase.CenterX ;
y=FDcase.CenterY ;
for i=1:1:length(num)
    fig=figure;
    fig.Units='centimeter' ;
    fig.OuterPosition=[2 2 17 17] ;
    clf

    subplot(3,1,[1,2]);
    pcolor(XX,YY,bathyData.depth) ;
    shading flat ;
    caxis([-0.1 0.1]) ; axis equal tight; hold on ;
    set(gca,'Ydir','reverse') ;
    xlim([0 8])
    plot(x(i,:),y(i,:),'Linewidth',1.5,'Color','r'); % plot debris trajectory
    title(['case = ', num2str(FDcase.caseNo(i),'%02d')]) ;
    xlabel('X [m]') ;
    ylabel('Y [m]') ;
    set(gca,'fontsize',15)

    % wave
    subplot(3,1,3)  ;
    tt=FDcase.TimeAtWaveGauge ;
    wg1=FDcase.waveDataAtGauge1 ;
    wg2=FDcase.waveDataAtGauge2 ;
    plot(tt(i,:),wg1(i,:),'Linewidth',1.5) ; % plot wg data at WG1
    hold on;grid on;grid minor;
    plot(tt(i,:),wg2(i,:),'Linewidth',1.5) ; % plot wg data at WG2
    xlabel('TIME [s]') ;
    ylabel('Water Elevation [m]') ;
    set(gca,'fontsize',15)
    ylim([-0.01 0.08])
    xlim([0 420])
    legend('wg1','wg2','Location','NorthWest','Orientation','horizontal') ;
    
end