%
% reading data and make figure
%

clear
fclose all ;

len=0.25; % length of debris objects 
wid=0.10; % width of debris objects

% for reading all data 
load('../raw_data/data.mat') ;

%  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  = 
% Data Contents in data.mat

% 2. FD/LDcase
%              -- waveDataAtGauge1(nCase,ntWave): time series of measured wave height at WG1
%              -- waveDataAtGauge2(nCase,ntWave): time series of measured wave height at WG2

figure(1)
clf
ncases=9;
t_interp=[0:0.01:420];
wg1_interp=zeros(length(t_interp),ncases*2);
for i=1:ncases
    tt=FDcase.TimeAtWaveGauge(i,:) ;
    wg1=FDcase.waveDataAtGauge1(i,:);
    wg1=wg1-mean(wg1(1:10)); % force to zero at beginning
    wg1_interp(:,i)=interp1(tt,wg1,t_interp);
    plot(tt,wg1,'Linewidth',1.5) ; % plot wg data at WG1
    hold on;grid on;grid minor;
    xlabel('TIME [s]') ;
    ylabel('Water Elevation [m]') ;
    set(gca,'fontsize',15)
end
for i=1:ncases
    tt=LDcase.TimeAtWaveGauge(i,:) ;
    wg1=LDcase.waveDataAtGauge1(i,:);
    wg1=wg1-mean(wg1(1:10)); % force to zero at beginning
    wg1_interp(:,i+ncases)=interp1(tt,wg1,t_interp);
    plot(tt,wg1,'Linewidth',1.5) ; % plot wg data at WG1
    hold on;grid on;grid minor;
    xlabel('TIME [s]') ;
    ylabel('Water Elevation [m]') ;
    set(gca,'fontsize',15)
end

wg1_mean=mean(wg1_interp,2);
plot(t_interp,wg1_mean,'r','LineWidth',4)
title('Recorded Water Surface Elevation at WG1: thin lines from individual trials, thick line is mean value')
print -djpeg100 WG1.jpg

figure(2)
clf
ncases=9;
wg2_interp=zeros(length(t_interp),ncases*2);
for i=1:ncases
    tt=FDcase.TimeAtWaveGauge(i,:) ;
    wg2=FDcase.waveDataAtGauge2(i,:);
    wg2=wg2-mean(wg2(1:10)); % force to zero at beginning
    wg2_interp(:,i)=interp1(tt,wg2,t_interp);
    plot(tt,wg2,'Linewidth',1.5) ; % plot wg data at WG2
    hold on;grid on;grid minor;
    xlabel('TIME [s]') ;
    ylabel('Water Elevation [m]') ;
    set(gca,'fontsize',15)
end
for i=1:ncases
    tt=LDcase.TimeAtWaveGauge(i,:) ;
    wg2=LDcase.waveDataAtGauge2(i,:);
    wg2=wg2-mean(wg2(1:10)); % force to zero at beginning
    wg2_interp(:,i+ncases)=interp1(tt,wg2,t_interp);
    plot(tt,wg2,'Linewidth',1.5) ; % plot wg data at WG1
    hold on;grid on;grid minor;
    xlabel('TIME [s]') ;
    ylabel('Water Elevation [m]') ;
    set(gca,'fontsize',15)
end

wg2_mean=mean(wg2_interp,2);
plot(t_interp,wg2_mean,'r','LineWidth',4)
title('Recorded Water Surface Elevation at WG2: thin lines from individual trials, thick line is mean value')
print -djpeg100 WG2.jpg

save t_WG.txt t_interp -ascii
save eta_WG1.txt wg1_mean -ascii
save eta_WG2.txt wg2_mean -ascii
